<?php
/**
 * Created by ra on 5/15/2015.
 */

if ( current_user_can( 'activate_plugins' ) ) {
	// deactivate a plugin from tgm
	if ( isset( $_GET['td_deactivate_plugin_slug'] ) ) {

		if ( empty( $_GET['td_magic_token'] ) || wp_verify_nonce( $_GET['td_magic_token'], 'td-panel-plugins' ) === false ) {
			echo 'Permission denied';
			die;
		}

		$td_deactivate_plugin_slug = $_GET['td_deactivate_plugin_slug'];
		if ( !empty($td_deactivate_plugin_slug) ) {
			$plugins = TGM_Plugin_Activation::$instance->plugins;
			foreach ( $plugins as $plugin ) {
				if ( $plugin['slug'] == $td_deactivate_plugin_slug ) {
					deactivate_plugins($plugin['file_path']);
					?>
                    <script type="text/javascript">
                        window.location = "admin.php?page=td_theme_plugins";
                    </script>
					<?php
					break;
				}
			}
		}
	}

	// Activate a plugin
	if ( isset($_GET['td_activate_plugin_slug']) ) {

		if ( empty($_GET['td_magic_token']) || wp_verify_nonce( $_GET['td_magic_token'], 'td-panel-plugins' ) === false ) {
			echo 'Permission denied';
			die;
		}

		$td_activate_plugin_slug = $_GET['td_activate_plugin_slug'];
		if ( !empty($td_activate_plugin_slug) ) {
			$plugins = TGM_Plugin_Activation::$instance->plugins;

			foreach ( $plugins as $plugin ) {
				if ( $plugin['slug'] == $td_activate_plugin_slug ) {
					activate_plugins($plugin['file_path']);
					?>
                    <script type="text/javascript">
                        window.location = "admin.php?page=td_theme_plugins";
                    </script>
					<?php
					break;
				}
			}
		}
	}
}

require_once TAGDIV_ROOT_DIR . "/includes/wp-booster/wp-admin/tagdiv-view-header.php";

?>

<div class="td-admin-wrap about-wrap theme-browser td-admin-plugins">
    <h1>پلاگین های پریمیوم را نصب کنید</h1>
    <div class="about-text">
        <p>
		پلاگین های ارائه شده را به راحتی نصب کنید. همه افزونه ها برای کار با موضوع به خوبی تست شده اند و ما آنها را به روز نگه می داریم. این موضوع با افزونه های برتر زیر بسته بندی شده است:
        </p>
    </div>

    <div class="td-admin-columns">
		<?php

		$wp_plugin_list = get_plugins();

		// Get plugins that require update
		$td_plugins_update_list = array();
        //there are issues with ABSPATH on wp.com servers, so we use WP_PLUGIN_DIR check $file_data bellow
        //$plugins_path = ABSPATH . 'wp-content/plugins';

		// Check for Plugin updates
		wp_update_plugins();
		$plugin_updates = get_site_transient( 'update_plugins' );

		foreach ( $plugin_updates as $index => $value ) {
			if ( $index == "response" ) {
				if( isset( $value["amp/amp.php"] ) ) {
					$td_amp_new_ver = $value["amp/amp.php"]->new_version;
				}
			}
		}

		foreach ( tagdiv_global::get_td_plugins() as $constant => $settings ) {
			$plugin_name = strtolower( str_replace('_', '-', $constant ) );
			$plugin = $plugin_name . '/' . $plugin_name . '.php';

			//Add AMP plugin to the update plugins list
			if ( $plugin == 'amp/amp.php' ) {
				if ( isset( $td_amp_new_ver ) ) {
					$td_plugins_update_list[] = $plugin;
					continue;
				}
			}

			if ( $plugin === 'td-subscription/td-subscription.php') {
			    if ( !empty($plugin_updates->response['td-subscription/td-subscription.php'])) {
				    $td_plugins_update_list[] = $plugin;
			    }
			}

			//plugin exists and it's inactive
			if ( !class_exists( $settings['class'], false ) && isset( $wp_plugin_list[$plugin] ) ) {

				//add AMP plugin to the update plugins list if it is inactive
				if ( $plugin == 'amp/amp.php' ) {
					if( isset( $td_amp_new_ver ) ) {
						$td_plugins_update_list[] = $plugin;
					}
					continue;
				}

				//read plugin file
				global $wp_filesystem;
                //there are issues with ABSPATH on wp.com servers, so we use WP_PLUGIN_DIR
                $file_data = $wp_filesystem->get_contents( WP_PLUGIN_DIR . '/' . $plugin );

                preg_match('/define\s*\(\s*\'' . $constant . '\',\s*\'(.*)\'\s*\)/', $file_data, $matches);

				if ( !isset($matches[1] ) || $matches[1] !==  $settings['version'] ) {
					$td_plugins_update_list[] = $plugin;
				}
			}
		}

		//asort($theme_plugins);
		$td_tgm_theme_plugins = TGM_Plugin_Activation::$instance->plugins;

		$sorted_plugins = array();
		$demo_plugins = array();

		// sort theme plugins based on the config array
		foreach ( tagdiv_global::$theme_plugins_list as $td_global_plugin ) {

			// don't add plugins that supposed to appear in theme's plugins list
			if ( !$td_global_plugin['td_show_in_theme_plugins']) {
                if ( !$td_global_plugin['td_demo_plugin'] ) {
                    continue;
                }
			}

			foreach ( $td_tgm_theme_plugins as $td_tgm_theme_plugin ) {

                if ( $td_global_plugin['name'] == $td_tgm_theme_plugin['name'] && $td_tgm_theme_plugin['td_demo_plugin'] ) {
                    $demo_plugins[] = $td_tgm_theme_plugin;
                }
				if ( $td_global_plugin['name'] == $td_tgm_theme_plugin['name'] &&  !$td_tgm_theme_plugin['td_demo_plugin'] ) {
					$sorted_plugins[] = $td_tgm_theme_plugin;
				}

            }

		}

        //echo '<pre>';
        //var_dump($td_plugins_update_list);
        //echo '</pre>';

		$td_tgm_theme_plugins = array_merge( $sorted_plugins, tagdiv_global::$theme_plugins_for_info_list );

		foreach ( $td_tgm_theme_plugins as $td_tgm_theme_plugin ) {

			$tmp_class = 'td-plugin-not-installed';
			$required_label = $td_tgm_theme_plugin['required_label'];
			$plugin_msg = '';

			if ( isset( $td_tgm_theme_plugin['file_path'] ) ) {
				// file_path key is missing from elements that come from td_global::$theme_plugins_for_info_list
				if ( tagdiv_util::is_active( $td_tgm_theme_plugin ) ) {

					//show update button for AMP even if it is active
					if ( $td_tgm_theme_plugin['file_path'] == 'amp/amp.php' && in_array ( $td_tgm_theme_plugin['file_path'],  $td_plugins_update_list ) ) {
						$tmp_class = 'td-plugin-update';
                    } else {
						$tmp_class = 'td-plugin-active';
						$required_label = 'active';
					}

					if ( $td_tgm_theme_plugin['file_path'] == 'td-subscription/td-subscription.php' && in_array ( $td_tgm_theme_plugin['file_path'],  $td_plugins_update_list ) ) {
						$tmp_class .= ' td-plugin-update';
					}

				} else if ( in_array ( $td_tgm_theme_plugin['file_path'],  $td_plugins_update_list) ) {
					$tmp_class = 'td-plugin-update';
				} else if ( isset( $wp_plugin_list[$td_tgm_theme_plugin['file_path']] ) ) {
					$tmp_class = 'td-plugin-inactive';
				}

			} else {
				$tmp_class = 'td-plugin-no-install';
			}

			?>
            <div class="td-wp-admin-plugin <?php echo esc_attr( $tmp_class ) ?>">

                <!-- Import content -->
                <div class="td-plugin-image">
                    <span class="td-plugin-required td-<?php echo esc_attr( $required_label ) ?>"><?php printf( '%1$s', $required_label ) ?></span>

                    <?php

                    if ($td_tgm_theme_plugin['slug'] === 'td-subscription' && is_plugin_active('td-subscription/td-subscription.php') && defined('TD_SUBSCRIPTION_VERSION')) {
                        ?>
                            <span class="td-plugin-version">V <?php printf( '%1$s', TD_SUBSCRIPTION_VERSION ) ?></span>
                        <?php
                    }

                    ?>

                    <img class="td-demo-thumb" src="<?php echo esc_url( $td_tgm_theme_plugin['img'] ) ?>"/>
                    <div class="td-plugin-meta">
                        <h3 class="theme-name"><?php printf( '%1$s', $td_tgm_theme_plugin['name'] ) ?></h3>
						<?php

						if ( $plugin_msg == '' ) {
							echo '<p>' . $td_tgm_theme_plugin['text'] . '</p>';
						} else {
							echo '<p class="td-plugin-notice">' . $plugin_msg . '</p><a href="' . admin_url( 'plugins.php' ) . '" target="_blank">Go to plugins</a>';
						}

						// for plugins like rev slider/tagdiv mobile theme or visual composer the source is not set
						$td_tgm_theme_plugin_source = '';
						if( isset( $td_tgm_theme_plugin['source'] ) ) {
							$td_tgm_theme_plugin_source = $td_tgm_theme_plugin['name'];
						}

						?>
                        <div class="td-plugin-buttons">
                            <a class="td-plugin-button td-button-install-plugin" href="<?php
							echo esc_url( wp_nonce_url(
								add_query_arg(
									array(
										'page'		  	=> urlencode(TGM_Plugin_Activation::$instance->menu),
										'plugin'		=> urlencode($td_tgm_theme_plugin['slug']),
										'plugin_name'   => urlencode($td_tgm_theme_plugin['name']),
										'plugin_source' => urlencode($td_tgm_theme_plugin_source),
										'tgmpa-install' => 'install-plugin',
										'return_url' => 'td_theme_plugins'
									),
									admin_url('themes.php')
								),
								'tgmpa-install',
                                'tgmpa-nonce'
							));
							?>">نصب کردن</a>
                            <a class="td-plugin-button td-button-update-plugin" href="<?php
							echo esc_url( wp_nonce_url(
								add_query_arg(
									array(
										'page'		  	=> urlencode(TGM_Plugin_Activation::$instance->menu),
										'plugin'		=> urlencode($td_tgm_theme_plugin['slug']),
										'plugin_name'   => urlencode($td_tgm_theme_plugin['name']),
										'plugin_source' => urlencode($td_tgm_theme_plugin_source),
										'tgmpa-update'  => 'update-plugin',
										'return_url'    => 'td_theme_plugins'
									),
									admin_url('themes.php')
								),
								'tgmpa-update',
								'tgmpa-nonce'
							));
							$op_name = 'Update';
							if ('td-subscription' === $td_tgm_theme_plugin['slug'] && !empty($plugin_updates->response['td-subscription/td-subscription.php'])) {
							    $op_name = 'Update to ' . $plugin_updates->response['td-subscription/td-subscription.php']->new_version;
                            }

							?>"><?php echo $op_name ?></a>
                            <a class="td-plugin-button td-button-uninstall-plugin" href="<?php
							echo esc_url(
								add_query_arg(
									array(
										'page'		  	            => urlencode('td_theme_plugins'),
										'td_deactivate_plugin_slug'	=> urlencode($td_tgm_theme_plugin['slug']),
										'td_magic_token' => wp_create_nonce('td-panel-plugins')
									),
									admin_url('admin.php')
								));
							?>"">غیر فعال کردن</a>
                            <a class="td-plugin-button td-button-activate-plugin" href="<?php
							echo esc_url(
								add_query_arg(
									array(
										'page'		  	            => urlencode('td_theme_plugins'),
										'td_activate_plugin_slug'	=> urlencode($td_tgm_theme_plugin['slug']),
										'td_magic_token' => wp_create_nonce('td-panel-plugins')
									),
									admin_url('admin.php')
								));
							?>"">فعال کردن</a>
                        </div>
                    </div>
                </div>
            </div>
			<?php
		}?>
    </div>

    <br>

<!--    <h1>Dedicated Plugins for Prebuilt Websites</h1>-->
<!--    <br>-->
    <div class="td-admin-accordion">
        <div class="td-admin-accordion-item">
            <div class="td-admin-accordion-title">
                <div class="td-admin-accordion-title-label">Dedicated Plugins for Prebuilt Websites</div>
                <div class="td-box-close-open-icon"></div>
            </div>

            <div class="td-admin-accordion-content">
                <div class="about-text">
                    <p> برخی از طراحی‌های وب‌سایت از پیش ساخته شده به یک افزونه خاص نیاز دارند تا طرح‌بندی‌های زیبا و عملکردی روان را ارائه دهند. در این بخش افزونه های اختصاصی رایگان را خواهید یافت. برای راحتی شما، افزونه ها همان نام طراحی وب سایت از پیش ساخته شده را دارند. پس لذت ببرید و یک وب سایت عالی بسازید!        </p>
                </div>

                <div class="td-admin-columns td-demo-plugins-install">
                    <?php foreach ($demo_plugins as $demo_plugin) {
                        $tmp_class = 'td-plugin-not-installed';
                        $required_label = $demo_plugin['required_label'];
                        $plugin_msg = '';

                        if ( isset( $demo_plugin['file_path'] ) ) {
                            //            var_dump($demo_plugin );

                            // file_path key is missing from elements that come from td_global::$theme_plugins_for_info_list
                            if ( tagdiv_util::is_active( $demo_plugin ) ) {
                                $tmp_class = 'td-plugin-active';
                                $required_label = 'active';

                            } else if ( isset( $wp_plugin_list[$demo_plugin['file_path']] ) ) {
                                $tmp_class = 'td-plugin-inactive';
                            }

                        } else {
                            $tmp_class = 'td-plugin-no-install';
                        }

                        ?>
                        <div class="td-wp-admin-plugin <?php echo esc_attr( $tmp_class ) ?>">

                            <!-- Import content -->
                            <div class="td-plugin-image">
                                <span class="td-plugin-required td-<?php echo esc_attr( $required_label ) ?>"><?php printf( '%1$s', $required_label ) ?></span>

                                <img class="td-demo-thumb" src="<?php echo esc_url( $demo_plugin['img'] ) ?>"/>
                                <div class="td-plugin-meta">
                                    <h3 class="theme-name"><?php printf( '%1$s', $demo_plugin['name'] ) ?></h3>
                                    <?php

                                    if ( $plugin_msg == '' ) {
                                        echo '<p>' . $demo_plugin['text'] . '</p>';
                                    } else {
                                        echo '<p class="td-plugin-notice">' . $plugin_msg . '</p><a href="' . admin_url( 'plugins.php' ) . '" target="_blank">Go to plugins</a>';
                                    }

                                    // for plugins like rev slider/tagdiv mobile theme or visual composer the source is not set
                                    $td_tgm_theme_plugin_source = '';
                                    if( isset( $demo_plugin['source'] ) ) {
                                        $td_tgm_theme_plugin_source = $demo_plugin['name'];
                                    }

                                    ?>
                                    <div class="td-plugin-buttons">
                                        <a class="td-plugin-button td-button-install-plugin" href="<?php
                                        echo esc_url( wp_nonce_url(
                                            add_query_arg(
                                                array(
                                                    'page'		  	=> urlencode(TGM_Plugin_Activation::$instance->menu),
                                                    'plugin'		=> urlencode($demo_plugin['slug']),
                                                    'plugin_name'   => urlencode($demo_plugin['name']),
                                                    'plugin_source' => urlencode($td_tgm_theme_plugin_source),
                                                    'tgmpa-install' => 'install-plugin',
                                                    'return_url' => 'td_theme_plugins'
                                                ),
                                                admin_url('themes.php')
                                            ),
                                            'tgmpa-install',
                                            'tgmpa-nonce'
                                        ));
                        ?>">نصب</a>
                                        <a class="td-plugin-button td-button-update-plugin" href="<?php
                                        echo esc_url( wp_nonce_url(
                                            add_query_arg(
                                                array(
                                                    'page'		  	=> urlencode(TGM_Plugin_Activation::$instance->menu),
                                                    'plugin'		=> urlencode($demo_plugin['slug']),
                                                    'plugin_name'   => urlencode($demo_plugin['name']),
                                                    'plugin_source' => urlencode($td_tgm_theme_plugin_source),
                                                    'tgmpa-update'  => 'update-plugin',
                                                    'return_url'    => 'td_theme_plugins'
                                                ),
                                                admin_url('themes.php')
                                            ),
                                            'tgmpa-update',
                                            'tgmpa-nonce'
                                        ));
                                        $op_name = 'Update';
                                        ?>"><?php echo $op_name ?></a>
                                        <a class="td-plugin-button td-button-uninstall-plugin" href="<?php
                                        echo esc_url(
                                            add_query_arg(
                                                array(
                                                    'page'		  	            => urlencode('td_theme_plugins'),
                                                    'td_deactivate_plugin_slug'	=> urlencode($demo_plugin['slug']),
                                                    'td_magic_token' => wp_create_nonce('td-panel-plugins')
                                                ),
                                                admin_url('admin.php')
                                            ));
                                        ?>">Deactivate</a>
                                        <a class="td-plugin-button td-button-activate-plugin" href="<?php
                                        echo esc_url(
                                            add_query_arg(
                                                array(
                                                    'page'		  	            => urlencode('td_theme_plugins'),
                                                    'td_activate_plugin_slug'	=> urlencode($demo_plugin['slug']),
                                                    'td_magic_token' => wp_create_nonce('td-panel-plugins')
                                                ),
                                                admin_url('admin.php')
                                            ));
                                        ?>">Activate</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <br>
    <br>

    <h1>پلاگین های تست شده</h1>
    <div class="about-text">
        <p>با انتشار هر تم، فهرستی از افزونه‌های کاملاً پشتیبانی شده را ارائه می‌کنیم. برای اینکه افزونه ها بهتر به نظر برسند و بهتر کار کنند، موضوع ممکن است شیوه نامه های سفارشی را اضافه کند و کد سفارشی را به آنها اضافه کند.
		ما به صورت دستی هر افزونه را به صورت دوره ای بررسی می کنیم. اگر چیزی را از دست دادیم، با ما تماس بگیرید!</p>
    </div>

    <div class="td-supported-plugin-list">
        <div class="td-supported-plugin"><p>سوپر کش WP</p><span> - افزونه کش</span></div>
        <div class="td-supported-plugin"><p>فرم تماس 7</p><span>- برای ایجاد فرم های تماس استفاده می شود</span></div>
        <div class="td-supported-plugin"><p>bbPress</p><span>- افزونه انجمن</span></div>
        <div class="td-supported-plugin"><p>BuddyPress</p><span>- افزونه شبکه اجتماعی</span></div>
		<div class="td-supported-plugin"><p>WPML</p><span>- افزونه چند زبانه وردپرس</span></div>
		<div class="td-supported-plugin"><p>منوهای فونت Awesome 4</p><span>- بسته آیکون، در منوهای تم پشتیبانی می شود</span></div>
        <div class="td-supported-plugin"><p>Jetpack</p><span>- افزونه با ویژگی های زیاد * ممکن است سایت شما را کند کند</span></div>
        <div class="td-supported-plugin"><p>WordPress (Yoast) SEO</p><span>- افزونه سئو</span></div>
        <div class="td-supported-plugin"><p>آواتار محلی ساده</p><span> - تغییر آواتار کاربران</span></div>
        <div class="td-supported-plugin"><p>رضایت کوکی GDPR</p><span> - پلاگین مطابقت با GDPR</span></div>
        <div class="td-supported-plugin"><p>بازاریابی همه کاره HubSpot</p><span> - لیست ایمیل خود را رشد دهید، سرنخ ایجاد کنید و مخاطبین را مدیریت کنید</span></div>
    </div>
</div>
